/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.object;

import java.util.EventObject;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.object.IsEventFrom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEventFromTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsEventFrom.eventFrom(null);
    }

    public void testEvaluatesToTrueIfArgumentIsAnEventObjectFiredByASpecifiedSource() {
        String o = "Source";
        EventObject ev = new EventObject(o);
        EventObject ev2 = new EventObject("source 2");
        Matcher isEventMatcher = IsEventFrom.eventFrom((Object)o);
        MatcherAssert.assertThat((Object)ev, (Matcher)isEventMatcher);
        IsEventFromTest.assertMismatchDescription("source was \"source 2\"", isEventMatcher, ev2);
    }

    public void testCanTestForSpecificEventClasses() {
        Object o = new Object();
        DerivedEvent goodEv = new DerivedEvent(o);
        DerivedEvent wrongSource = new DerivedEvent("wrong source");
        EventObject wrongType = new EventObject(o);
        EventObject wrongSourceAndType = new EventObject(new Object());
        Matcher isEventMatcher = IsEventFrom.eventFrom(DerivedEvent.class, (Object)o);
        MatcherAssert.assertThat((Object)goodEv, (Matcher)isEventMatcher);
        IsEventFromTest.assertMismatchDescription("source was \"wrong source\"", isEventMatcher, wrongSource);
        IsEventFromTest.assertMismatchDescription("item type was java.util.EventObject", isEventMatcher, wrongType);
        IsEventFromTest.assertMismatchDescription("item type was java.util.EventObject", isEventMatcher, wrongSourceAndType);
    }

    private static class DerivedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public DerivedEvent(Object source) {
            super(source);
        }
    }
}

